(function () {
  function render(container, data, units) {
    var temp = typeof data.temperature === 'number' ? Math.round(data.temperature) : '-';
    var wind = data.windSpeed != null ? Math.round(data.windSpeed) + (units === 'imperial' ? ' mph' : ' km/h') : '-';
    var hum = data.humidity != null ? data.humidity + '%' : '-';
    var cond = data.summary || '—';
    container.innerHTML = '' +
      '<div style="font-family: system-ui, -apple-system, Segoe UI, Roboto; border:1px solid #e5e7eb; border-radius:12px; padding:12px; max-width:260px; box-shadow:0 1px 4px rgba(0,0,0,.06);">' +
      '  <div style="display:flex; align-items:center; justify-content:space-between;">' +
      '    <div style="font-weight:600;">Dharamshala</div>' +
      '    <div style="opacity:.7; font-size:12px;">' + (new Date(data.observedAt || Date.now())).toLocaleTimeString() + '</div>' +
      '  </div>' +
      '  <div style="display:flex; align-items:flex-end; gap:8px; margin-top:8px;">' +
      '    <div style="font-size:40px; font-weight:700; line-height:1;">' + temp + '°' + (units === 'imperial' ? 'F' : 'C') + '</div>' +
      '    <div style="opacity:.8;">' + cond + '</div>' +
      '  </div>' +
      '  <div style="display:flex; gap:12px; margin-top:8px; font-size:12px; opacity:.85;">' +
      '    <div>Wind: ' + wind + '</div>' +
      '    <div>Humidity: ' + hum + '</div>' +
      '  </div>' +
      '  <div style="margin-top:8px; font-size:11px; opacity:.7;">' +
      '    Powered by <a href="https://dharamshala-weather.site" target="_blank" rel="noopener">dharamshala-weather.site</a>' +
      '  </div>' +
      '</div>';
  }

  function init() {
    var el = document.getElementById('dh-weather-widget');
    if (!el) return;
    var lat = el.getAttribute('data-lat');
    var lon = el.getAttribute('data-lon');
    var units = el.getAttribute('data-units') === 'imperial' ? 'imperial' : 'metric';

    var url = '/i.php?action=widget_current&lat=' + encodeURIComponent(lat || '') + '&lon=' + encodeURIComponent(lon || '') + '&units=' + units;

    fetch(url, { credentials: 'omit' })
      .then(function (r) { return r.ok ? r.json() : Promise.reject(new Error('Bad response')); })
      .then(function (json) { render(el, json, units); })
      .catch(function () { render(el, {}, units); });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();

