# Dharamshala Weather – Recovery and Technical Plan

This document captures the immediate recovery steps and the technical/content roadmap to get `dharamshala-weather.site` online, crawlable, and competitive.

## Phase 1 – Critical Site Recovery

1) Verify hosting/DNS and server availability
- Domain DNS must point to the correct server IP (A/AAAA records).
- Server must respond with HTTP 200 for `https://dharamshala-weather.site/` and `https://dharamshala-weather.site/robots.txt`.
- Ensure firewall/WAF/CDN is not blocking Googlebot or public traffic.

2) robots.txt
- A permissive robots file has been added at `public/robots.txt`:
```
User-agent: Googlebot
Allow: /

User-agent: *
Allow: /

Sitemap: https://dharamshala-weather.site/sitemap.xml
```
- If you have a sitemap, ensure it is reachable; otherwise, remove the Sitemap line until available.

3) Google Search Console (GSC)
- Verify property for `https://dharamshala-weather.site/`. You can use HTML file verification (files already exist: `public/google*.html`) or DNS TXT.
- Use URL Inspection in GSC to request indexing of the homepage once the site returns HTTP 200.

4) Basic health checks
- `curl -I https://dharamshala-weather.site/` → expect `200 OK`.
- `curl -I https://dharamshala-weather.site/robots.txt` → expect `200 OK` with above content.
- Ensure TLS certificate is valid and not expired.

## Phase 2 – Technical & Content Foundation

1) Commercial weather data feed
- Shortlist providers: OpenWeather One Call 3.0, Tomorrow.io, AerisWeather, AccuWeather API, Visual Crossing.
- Criteria: Dharamshala coverage quality, hourly + daily forecast, precipitation amount, wind, humidity, and license that permits public display + caching.

2) Minimum viable product (MVP)
- Current conditions, hourly forecast (next 24–48h), daily forecast (7–10 days), precip chance/amount, humidity, wind speed/direction.
- Mobile-first layout with fast load; target Core Web Vitals “Good”.

3) Structured data
- Use schema.org `WeatherForecast` JSON-LD. Template added at `public/schema-weather-example.jsonld`.
- Populate dynamically for each page view with current/hourly/daily slices.

4) Performance
- Optimize images, defer non-critical JS, preconnect to API domains, HTTP caching (ETag/Cache-Control), and server compression (gzip/br).

## Phase 3 – Strategic Differentiation (Trekker Focus)

- Create dedicated pages for: Triund, Kareri Lake, Indrahar Pass with hourly forecasts and safety notes.
- Publish expert guides: packing lists by season, wind chill/frostbite risks at altitude, trekking safety in Dharamshala.
- Consider a “Trekking Safety Index” combining weather, visibility, and AQI.

## Phase 4 – Authority and Links

- Free embeddable widget for local hotels/trek agencies with a small “Powered by” link.
- Local citations on tourism/business directories and targeted outreach to trekking blogs.

## Widget

- Files: `public/widget.js` and `public/widget-demo.html` will be used for the embed.
- Embed example (replace origin if hosting elsewhere):
```html
<div id="dh-weather-widget" data-lat="32.219" data-lon="76.323" data-units="metric"></div>
<script async src="https://dharamshala-weather.site/widget.js"></script>
```
- `widget.js` expects a public endpoint returning current conditions; wire this to your data provider.

## Next Steps

- Wire `libraries/Weather.php` to a commercial data provider and expose a lightweight JSON endpoint (e.g., `GET /i.php?action=widget_current&lat=..&lon=..`).
- Render JSON-LD from server-side templates in `public/themes/weather/views/home/*.php` using real data.
- Add sitemap.xml and ensure it is referenced in robots.txt.
- After go-live, validate with: PageSpeed Insights, GSC Rich Results Test, and live URL inspection.

